/*
 * Decompiled with CFR 0.152.
 */
package org.sourcecodede.fallingtrees;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FallingTrees
extends JavaPlugin
implements Listener {
    private final Set<Location> placedLogs = new HashSet<Location>();
    private static final int RADIUS = 4;

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlockPlaced();
        if (this.isLog(block.getType())) {
            this.placedLogs.add(block.getLocation());
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (this.isLog(block.getType()) && !this.placedLogs.contains(block.getLocation())) {
            this.breakTree(block);
        }
    }

    private void breakTree(Block startBlock) {
        HashSet<Location> visited = new HashSet<Location>();
        HashSet<Block> toBreak = new HashSet<Block>();
        Location origin = startBlock.getLocation();
        for (int dx = -4; dx <= 4; ++dx) {
            for (int dy = 0; dy <= 20; ++dy) {
                for (int dz = -4; dz <= 4; ++dz) {
                    Location checkLoc = origin.clone().add((double)dx, (double)dy, (double)dz);
                    if (visited.contains(checkLoc)) continue;
                    visited.add(checkLoc);
                    Block current = checkLoc.getBlock();
                    if (!this.isLeav(current.getType()) && (!this.isLog(current.getType()) && !this.isWood(current.getType()) && !this.isStem(current.getType()) || this.placedLogs.contains(current.getLocation()))) continue;
                    toBreak.add(current);
                }
            }
        }
        for (Block block : toBreak) {
            block.breakNaturally();
        }
    }

    private boolean isLog(Material material) {
        return material.name().endsWith("_LOG");
    }

    private boolean isWood(Material material) {
        return material.name().endsWith("_WOOD");
    }

    private boolean isStem(Material material) {
        return material.name().endsWith("_STEM");
    }

    private boolean isLeav(Material material) {
        return material.name().endsWith("_LEAVES");
    }
}

